package ftp;
import java.io.File;
import java.io.PrintStream;

public class CommandeRMDIR extends Commande {
	
	public CommandeRMDIR(PrintStream ps, String commandeStr) {
		super(ps, commandeStr);
	}

	public void execute() {
		
		// Si la commande n'a pas d'argument, envoyer un message d'erreur.
		if (commandeArgs.length == 0)
		{
			ps.println("2 Un nom de dossier doit être présent dans la commande.");
		}
		else
		{
			// Obtention du dossier à supprimer.
			File newDir = new File(CommandExecutor.currentFile.getAbsolutePath() + "\\" + commandeArgs[0]);
			
			// Si le dossier n'existe pas, envoyer un message d'erreur.
			if (!newDir.exists())
			{
				ps.println("2 Le dossier rentré n'existe pas.");
				return;
			}
			
			// Suppression du dossier.
			newDir.delete();
			
			// Si le dossier n'existe pas, envoyer un message de confirmation, sinon un message d'erreur.
			if (!newDir.exists())
			{
				ps.println("0 Le dossier a été correctement supprimé.");
			}
			else
			{
				ps.println("2 La dosier n'a pas été supprimé.");
			}
			
		}
		
	}
	



}
